import multer from 'multer';
import { dirname, join } from 'path';

const CURRENT_DIR = dirname(__dirname);
const Storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, join(CURRENT_DIR, '/uploads'));
  },
  filename: function (req: any, file: any, cb: any) {
    cb(null, file.originalname);
  },
});

const FileFilter = (req: any, file: any, cb: any) => {
  if (
    file.mimetype === 'image/jpg' ||
    file.mimetype === 'image/jpeg' ||
    file.mimetype === 'image/png'
  ) {
    cb(null, true);
  } else {
    cb(new Error('Image uploaded is not of type jpg,jpeg or png'), false);
  }
};

const uploadcampaig = multer({ storage: Storage, fileFilter: FileFilter });

export default uploadcampaig;
