import { Request, Response } from 'express';
import { Mails } from '../entities/mails';
import connection from '../connections/mysqlConn';
import nodemailer from 'nodemailer';
import SMTPTransport from 'nodemailer/lib/smtp-transport';

export const create = async (req: Request, res: Response) => {
  console.log('se invoca el servicio crear correo', new Date().toLocaleString());
  const { mailer, section, subject, message, user, phone } = req.body;

  const mails = new Mails(mailer, section, subject, message, user, phone);
  if (!mails) return res.status(400).json({ message: 'Error formato correo' });
  // Transport para Gmail 465 (SSL implícito)
  const transporter = nodemailer.createTransport({
      host: 'smtp.gmail.com',
      port: 465,
      secure: true, // 465 => true
      auth: {
        user: 'desarrollo@institutodeltorax.com',
        pass: 'lvbyebifwhpbndbx', // App Password de Google
      },
      connectionTimeout: 20_000,
      greetingTimeout: 15_000,
      socketTimeout: 30_000,
      dnsTimeout: 10_000,
      family: 4, // fuerza IPv4
      tls: {
        servername: 'smtp.gmail.com', // SNI correcto
        minVersion: 'TLSv1.2',
        // NO USAR EN PROD: rejectUnauthorized: false
      },
      logger: true,
      debug: true,
    } as SMTPTransport.Options);

  // Verifica disponibilidad SMTP antes de enviar (útil en prod)
  try {
    await transporter.verify();
    console.log('SMTP listo para enviar');
  } catch (e) {
    const errTxt = serializeErr(e);
    console.error('SMTP verify error:', errTxt);
    await insertMail(mails, 0, `verify_error: ${errTxt}`);
    return res.status(502).json({ message: 'No se pudo verificar el SMTP' });
  }

  // Envío
  try {
    const info = await transporter.sendMail({
      from: 'Contacto desde <desarrollo@institutodeltorax.com>', // debe ser alias permitido
      to: 'comunicaciones@institutodeltorax.com',
      subject: `[${mails.getSection()}] ${mails.getSubject()}`,
      html: `
        <p>Sección: ${mails.getSection()}</p>
        <p>Nombre: ${mails.getUser()}</p>
        <p>Correo: ${mails.getMailer()}</p>
        <p>Teléfono: ${mails.getPhone()}</p>
        <p>Mensaje: ${mails.getMessage()}</p>
      `,
    });

    console.log('send ok:', info.messageId);
    await insertMail(mails, 1, String(info.response || info.messageId || 'OK'));
    return res.json({ message: 'email enviado con éxito' });
  } catch (e) {
    const errTxt = serializeErr(e);
    console.error('send error:', errTxt);
    await insertMail(mails, 0, errTxt);
    return res.status(502).json({ message: 'Se presentó error en el envío' });
  }
};

// Helpers
function serializeErr(e: any) {
  try {
    return JSON.stringify(e, Object.getOwnPropertyNames(e));
  } catch {
    return String(e?.message || e);
  }
}

function insertMail(mails: Mails, state: 0 | 1, errorOrInfo: string) {
  return new Promise<void>((resolve, reject) => {
    connection.query(
      'INSERT INTO mails SET ?, ?',
      [mails, { state, error: errorOrInfo }],
      (err) => (err ? reject(err) : resolve())
    );
  });
}