import { Request, Response } from 'express';
import { Campaig } from '../entities/campaig';
import connection from '../connections/mysqlConn';

export const create = async (req: Request, res: Response) => {
  console.log('se invoca el servicio crear campaña', new Date(Date.now()).toLocaleString());
  const { name, status } = req.body;
  const image = req.file?.filename;
  const campaig: Campaig = new Campaig(name, image!, status);
  if (!campaig) {
    res.json({ message: 'Error fomato campaña' });
  }
  connection.query(
    'INSERT INTO campaig (name, image, status) VALUES (?,?,?)',
    [campaig.getName(), campaig.getImage(), campaig.getStatus()],
    function (err, result, fields) {
      if (err) {
        res.json(err);
      }
      res.json({ message: 'Campaña creada con éxito' });
    }
  );
};

export const show = async (req: Request, res: Response) => {
  console.log('se invoca el servicio listar campañas', new Date(Date.now()).toLocaleString());
  connection.query('SELECT * FROM campaig', function (err, result, fields) {
    if (err) {
      res.json(err);
    }
    res.json(result);
  });
};

export const deleteCamapaig = async (req: Request, res: Response) => {
  console.log('se invoca el servicio eliminar campañas', new Date(Date.now()).toLocaleString());
  const { name } = req.params;
  connection.query('DELETE FROM campaig where name=?', [name], function (err, result, fields) {
    if (err) {
      res.json(err);
    }
    res.json({ message: `Campaña ${name} borrada con éxito` });
  });
};
