import express, { Express } from 'express';
import cors from 'cors';
import routers from './routers';

const app: Express = express();

const allowedOrigins = [
  'https://institutodeltorax.com',
  'http://localhost:3000',
  'https://www.institutodeltorax.com',
  'http://localhost',
];
const options: cors.CorsOptions = {
  origin: allowedOrigins,
};

app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(cors(options));
app.use(routers);

app.listen(5000, () => {
  console.log('Servidor corriendo en puerto 5000');
});
