"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const multer_1 = __importDefault(require("multer"));
const path_1 = require("path");
const CURRENT_DIR = (0, path_1.dirname)(__dirname);
const Storage = multer_1.default.diskStorage({
    destination: function (req, file, cb) {
        cb(null, (0, path_1.join)(CURRENT_DIR, '/uploads'));
    },
    filename: function (req, file, cb) {
        cb(null, file.originalname);
    },
});
const FileFilter = (req, file, cb) => {
    if (file.mimetype === 'image/jpg' ||
        file.mimetype === 'image/jpeg' ||
        file.mimetype === 'image/png') {
        cb(null, true);
    }
    else {
        cb(new Error('Image uploaded is not of type jpg,jpeg or png'), false);
    }
};
const uploadcampaig = (0, multer_1.default)({ storage: Storage, fileFilter: FileFilter });
exports.default = uploadcampaig;
