"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
const mails_1 = require("../entities/mails");
const mysqlConn_1 = __importDefault(require("../connections/mysqlConn"));
const nodemailer_1 = __importDefault(require("nodemailer"));
const create = async (req, res) => {
    console.log('se invoca el servicio crear correo', new Date().toLocaleString());
    const { mailer, section, subject, message, user, phone } = req.body;
    const mails = new mails_1.Mails(mailer, section, subject, message, user, phone);
    if (!mails)
        return res.status(400).json({ message: 'Error formato correo' });
    // Transport para Gmail 465 (SSL implícito)
    const transporter = nodemailer_1.default.createTransport({
        host: 'smtp.gmail.com',
        port: 465,
        secure: true,
        auth: {
            user: 'desarrollo@institutodeltorax.com',
            pass: 'lvbyebifwhpbndbx', // App Password de Google
        },
        connectionTimeout: 20000,
        greetingTimeout: 15000,
        socketTimeout: 30000,
        dnsTimeout: 10000,
        family: 4,
        tls: {
            servername: 'smtp.gmail.com',
            minVersion: 'TLSv1.2',
            // NO USAR EN PROD: rejectUnauthorized: false
        },
        logger: true,
        debug: true,
    });
    // Verifica disponibilidad SMTP antes de enviar (útil en prod)
    try {
        await transporter.verify();
        console.log('SMTP listo para enviar');
    }
    catch (e) {
        const errTxt = serializeErr(e);
        console.error('SMTP verify error:', errTxt);
        await insertMail(mails, 0, `verify_error: ${errTxt}`);
        return res.status(502).json({ message: 'No se pudo verificar el SMTP' });
    }
    // Envío
    try {
        const info = await transporter.sendMail({
            from: 'Contacto desde <desarrollo@institutodeltorax.com>',
            to: 'comunicaciones@institutodeltorax.com',
            subject: `[${mails.getSection()}] ${mails.getSubject()}`,
            html: `
        <p>Sección: ${mails.getSection()}</p>
        <p>Nombre: ${mails.getUser()}</p>
        <p>Correo: ${mails.getMailer()}</p>
        <p>Teléfono: ${mails.getPhone()}</p>
        <p>Mensaje: ${mails.getMessage()}</p>
      `,
        });
        console.log('send ok:', info.messageId);
        await insertMail(mails, 1, String(info.response || info.messageId || 'OK'));
        return res.json({ message: 'email enviado con éxito' });
    }
    catch (e) {
        const errTxt = serializeErr(e);
        console.error('send error:', errTxt);
        await insertMail(mails, 0, errTxt);
        return res.status(502).json({ message: 'Se presentó error en el envío' });
    }
};
exports.create = create;
// Helpers
function serializeErr(e) {
    try {
        return JSON.stringify(e, Object.getOwnPropertyNames(e));
    }
    catch {
        return String(e?.message || e);
    }
}
function insertMail(mails, state, errorOrInfo) {
    return new Promise((resolve, reject) => {
        mysqlConn_1.default.query('INSERT INTO mails SET ?, ?', [mails, { state, error: errorOrInfo }], (err) => (err ? reject(err) : resolve()));
    });
}
