"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteCamapaig = exports.show = exports.create = void 0;
const campaig_1 = require("../entities/campaig");
const mysqlConn_1 = __importDefault(require("../connections/mysqlConn"));
const create = async (req, res) => {
    console.log('se invoca el servicio crear campaña', new Date(Date.now()).toLocaleString());
    const { name, status } = req.body;
    const image = req.file?.filename;
    const campaig = new campaig_1.Campaig(name, image, status);
    if (!campaig) {
        res.json({ message: 'Error fomato campaña' });
    }
    mysqlConn_1.default.query('INSERT INTO campaig (name, image, status) VALUES (?,?,?)', [campaig.getName(), campaig.getImage(), campaig.getStatus()], function (err, result, fields) {
        if (err) {
            res.json(err);
        }
        res.json({ message: 'Campaña creada con éxito' });
    });
};
exports.create = create;
const show = async (req, res) => {
    console.log('se invoca el servicio listar campañas', new Date(Date.now()).toLocaleString());
    mysqlConn_1.default.query('SELECT * FROM campaig', function (err, result, fields) {
        if (err) {
            res.json(err);
        }
        res.json(result);
    });
};
exports.show = show;
const deleteCamapaig = async (req, res) => {
    console.log('se invoca el servicio eliminar campañas', new Date(Date.now()).toLocaleString());
    const { name } = req.params;
    mysqlConn_1.default.query('DELETE FROM campaig where name=?', [name], function (err, result, fields) {
        if (err) {
            res.json(err);
        }
        res.json({ message: `Campaña ${name} borrada con éxito` });
    });
};
exports.deleteCamapaig = deleteCamapaig;
