"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const documentRouter_1 = __importDefault(require("./src/routers/documentRouter"));
const campaigRouter_1 = __importDefault(require("./src/routers/campaigRouter"));
const mailRouter_1 = __importDefault(require("./src/routers/mailRouter"));
const imageRouter_1 = __importDefault(require("./src/routers/imageRouter"));
const routers = (0, express_1.Router)();
routers.use('/documents', documentRouter_1.default);
routers.use('/campaig', campaigRouter_1.default);
routers.use('/mails', mailRouter_1.default);
routers.use('/dist/src/uploads', imageRouter_1.default);
exports.default = routers;
