"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const cors_1 = __importDefault(require("cors"));
const routers_1 = __importDefault(require("./routers"));
const app = (0, express_1.default)();
const allowedOrigins = [
    'https://institutodeltorax.com',
    'http://localhost:3000',
    'https://www.institutodeltorax.com',
    'http://localhost',
];
const options = {
    origin: allowedOrigins,
};
app.use(express_1.default.json());
app.use(express_1.default.urlencoded({ extended: true }));
app.use((0, cors_1.default)(options));
app.use(routers_1.default);
app.listen(5000, () => {
    console.log('Servidor corriendo en puerto 5000');
});
